// gameticks.c

#include "gameticks.h"

unsigned long baseTickCount, freezeTickCount;
int freezeLevel;

void InitGameTickCount( void )
{
	baseTickCount = freezeTickCount = 0;
	freezeLevel = 0;
}

void FreezeGameTickCount( void )
{
	if( freezeLevel	== 0 ) freezeTickCount = TickCount( );
	freezeLevel--;
}

void UnfreezeGameTickCount( void )
{
	freezeLevel++;
	if( freezeLevel >= 0 )
	{
		freezeLevel = 0;
		baseTickCount += TickCount( ) - freezeTickCount;
	}
}

unsigned long GameTickCount( void )
{
	unsigned long ticks;
	
	if( freezeLevel < 0 )
	{
		UnfreezeGameTickCount( );
		ticks = TickCount( ) - baseTickCount;
		FreezeGameTickCount( );
	}
	else
		ticks = TickCount( ) - baseTickCount;
	
	return ticks;
}